{********************************************
; File: MIDI.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT MIDI;
INTERFACE
USES TYPES;
CONST


{ MIDI }
miToolNum = $0020;  { the tool number of the MIDI Tool Set }
miDrvrFileType = $00BB;  { filetype of MIDI device driver }
miNSVer = $0102;  { minimum version of Note Synthesizer required by MIDI Tool Set }
miSTVer = $0203;  { minimum version of Sound Tools needed by MIDI Tool Set }
miDrvrAuxType = $0300;  { aux type of MIDI device driver }

{ Error Codes }
miStartUpErr = $2000;  { MIDI Tool Set is not started  }
miPacketErr = $2001;  { incorrect length for a received MIDI command }
miArrayErr = $2002;  { a designated array had an insufficient or illegal size }
miFullBufErr = $2003;  { input buffer overflow }
miToolsErr = $2004;  { the required tools were not started up or had insufficient versions }
miOutOffErr = $2005;  { MIDI output must first be enabled }
miNoBufErr = $2007;  { no buffer is currently allocated }
miDriverErr = $2008;  { the designated file is not a legal MIDI device driver }
miBadFreqErr = $2009;  { the MIDI clock cannot attain the requested frequency }
miClockErr = $200A;  { the MIDI clock value wrapped to zero }
miConflictErr = $200B;  { conflicting processes for MIDI input }
miNoDevErr = $200C;  { no MIDI device driver loaded }
miDevNotAvail = $2080;  { the requested device is not available }
miDevSlotBusy = $2081;  { requested slot is already in use }
miDevBusy = $2082;  { the requested device is already in use }
miDevOverrun = $2083;  { device overrun by incoming MIDI data }
miDevNoConnect = $2084;  { no connection to MIDI }
miDevReadErr = $2085;  { framing error in received MIDI data }
miDevVersion = $2086;  { ROM version is incompatible with device driver }
miDevIntHndlr = $2087;  { conflicting interrupt handler is installed }

{ MidiClock }
miSetClock = $0000;  { set time stamp clock }
miStartClock = $0001;  { start time stamp clock }
miStopClock = $0002;  { stop time stamp clock }
miSetFreq = $0003;  { set clock frequency }

{ MidiControl }
miRawMode = $00000000;  { raw mode for MIDI input and output }
miSetRTVec = $0000;  { set real-time message vector }
miPacketMode = $00000001;  { packet mode for MIDI input and output }
miSetErrVec = $0001;  { set real-time error vector }
miStandardMode = $00000002;  { standard mode for MIDI input and output }
miSetInBuf = $0002;  { set input buffer information }
miSetOutBuf = $0003;  { set output buffer information }
miStartInput = $0004;  { start MIDI input }
miStartOutput = $0005;  { start MIDI output }
miStopInput = $0006;  { stop MIDI input }
miStopOutput = $0007;  { stop MIDI output }
miFlushInput = $0008;  { discard contents of input buffer }
miFlushOutput = $0009;  { discard contents of output buffer }
miFlushPacket = $000A;  { discard next input packet }
miWaitOutput = $000B;  { wait for output buffer to empty }
miSetInMode = $000C;  { set input mode }
miSetOutMode = $000D;  { set output mode }
miClrNotePad = $000E;  { clear all notes marked on in the note pad }
miSetDelay = $000F;  { set minimum delay between output packets }
miOutputStat = $0010;  { enable/disable output of running-status }
miIgnoreSysEx = $0011;  { ignore system exclusive input }

{ MidiDevice }
miSelectDrvr = $0000;  { display device driver selection dialog }
miLoadDrvr = $0001;  { load and initialize device driver }
miUnloadDrvr = $0002;  { shutdown MIDI device, unload driver }

{ MidiInfo }
miNextPktLen = $0000;  { return length of next packet }
miInputChars = $0001;  { return number of characters in input buffer }
miOutputChars = $0002;  { return number of characters in output buffer }
miMaxInChars = $0003;  { return maximum number of characters in input buffer }
miMaxOutChars = $0004;  { return maximum number of characters in output buffer }
miRecordAddr = $0005;  { return current MidiRecordSeq address }
miPlayAddr = $0006;  { return current MidiPlaySeq address }
miClockValue = $0007;  { return current time stamp clock value }
miClockFreq = $0008;  { return number of clock ticks per second }

TYPE
MiBufInfo = RECORD
    bufSize : Integer; { size of buffer (0 for default) }
    address : Ptr; { address of buffer (0 for auto-allocation) }
END;
MiDriverInfoPtr = ^MiDriverInfo;
MiDriverInfo = RECORD
    slot : Integer; { device slot }
    external : Integer; { slot internal (=0) / external (=1) }
    pathname : String[64]; { device driver pathname }
END;
PROCEDURE MidiBootInit   ;
PROCEDURE MidiClock ( funcNum:Integer; arg:Longint)  ;
PROCEDURE MidiControl ( funcNum:Integer; arg:Longint)  ;
PROCEDURE MidiDevice ( funcNum:Integer; driverInfo:MiDriverInfoPtr)  ;
FUNCTION MidiInfo ( funcNum:Integer) : Longint ;
PROCEDURE MidiInputPoll   ;
FUNCTION MidiReadPacket ( arrayAddr:Ptr; arraySize:Integer) : Integer ;
PROCEDURE MidiReset   ;
PROCEDURE MidiShutDown   ;
PROCEDURE MidiStartUp ( userID:Integer; dPageAddr:Integer)  ;
FUNCTION MidiStatus  : Boolean ;
FUNCTION MidiVersion  : Integer ;
FUNCTION MidiWritePacket ( arrayAddr:Ptr) : Integer ;
IMPLEMENTATION
END.
